resource "aws_vpc_endpoint" "twitch-gds-prod-validator-endpoint" {
  service_name = "com.amazonaws.vpce.us-west-2.vpce-svc-017a1ed0d8abc2e8c"
  vpc_id = "${var.vpc_id}"
  vpc_endpoint_type = "Interface"
  security_group_ids = ["${aws_security_group.twitch-gds-validator-sgroup.id}"]
  subnet_ids = ["${var.private_subnet_ids}"]
}

resource "aws_vpc_endpoint" "twitch-gds-dev-validator-endpoint" {
  service_name = "com.amazonaws.vpce.us-west-2.vpce-svc-0b1d907fce92ca070"
  vpc_id = "${var.vpc_id}"
  vpc_endpoint_type = "Interface"
  security_group_ids = ["${aws_security_group.twitch-gds-validator-sgroup.id}"]
  subnet_ids = ["${var.private_subnet_ids}"]
}

resource "aws_security_group" "twitch-gds-validator-sgroup" {
  name = "twitch-gds-validator-sgroup"
  description = "Allow traffic over PrivateLink to Validator"
  vpc_id = "${var.vpc_id}"

  ingress {
    from_port = 80
    protocol = "TCP"
    to_port = 80
    cidr_blocks = ["${var.private_subnet_cidrs}"]
  }

  egress {
    from_port = 0
    protocol = "-1"
    to_port = 0
    cidr_blocks = ["${var.private_subnet_cidrs}"]
  }
}

resource "aws_route53_record" "prod-validator-plink" {
  name = "prod-valdiator-endpoint"
  type = "CNAME"
  ttl = 60
  zone_id = "${var.root_zone_id}"
  records = ["${lookup(aws_vpc_endpoint.twitch-gds-prod-validator-endpoint.dns_entry[0], "dns_name")}"]
}

resource "aws_route53_record" "dev-validator-plink" {
  name = "dev-valdiator-endpoint"
  type = "CNAME"
  ttl = 60
  zone_id = "${var.root_zone_id}"
  records = ["${lookup(aws_vpc_endpoint.twitch-gds-dev-validator-endpoint.dns_entry[0], "dns_name")}"]
}
