// IMPORTED NLB - CREATED BY k8s/kops
resource "aws_lb" "smart-lb" {
  name = "ad37f314a68f911e8937a0220ed1f4e4"
  load_balancer_type = "network"
  tags {
    "KubernetesCluster" = "us-west-2.prod.smart.extensions.twitch.a2z.com"
    "kubernetes.io/cluster/us-west-2.prod.smart.extensions.twitch.a2z.com" = "owned"
    "kubernetes.io/service-name" = "smart/smart-deployment"
    "datadog" = "true"
  }
}

resource "aws_vpc_endpoint_service" "smart-dev-service-endpoint" {
  acceptance_required = false
  network_load_balancer_arns = ["${aws_lb.smart-lb.arn}"]
  allowed_principals = ["arn:aws:iam::465369119046:root", "arn:aws:iam::641044725657:root"]
  //  465369119046 = twitch-web-dev
  //  641044725657 = twitch-web-aws
}
