package api

import (
	"context"

	"code.justin.tv/extensions/smart/services/smart/rpc"
)

// GetLatestMessage gets the last stored message for a given topic.
// If no message is  found 404 Is the error code returned
func (a API) GetLatestMessage(ctx context.Context, req *smartrpc.Topic) (*smartrpc.Message, error) {
	topic := req

	// TODO add auth
	mes, err := a.Store.GetLatestMessage(topicToString(topic.ChannelId, topic.ExtensionId, topic.Target))
	if err != nil {
		return nil, smartrpc.NewMappedTwirpError(err.Error(), smartrpc.ErrMessageNotFound)
	}
	return messageToMessage(mes), nil
}
