package api

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"

	"code.justin.tv/extensions/smart/services/smart/rpc"
	store "code.justin.tv/extensions/smart/services/smart/store/mocks"
)

func TestGetLatestMessage(t *testing.T) {
	req := &smartrpc.Topic{
		ChannelId:   "test",
		ExtensionId: "test",
		Target:      "test",
	}

	t.Run("when the store is bad", func(t *testing.T) {
		a := &API{Store: &store.AlwaysFail{}}
		m, err := a.GetLatestMessage(context.Background(), req)
		assert.NotNil(t, err)
		assert.Nil(t, m)
	})

	t.Run("when everything is good", func(t *testing.T) {
		a := &API{Store: &store.AlwaysPass{}}
		m, err := a.GetLatestMessage(context.Background(), req)
		assert.Nil(t, err)
		assert.NotNil(t, m, 0)
	})

}
