package api

import (
	"context"
	"fmt"
	"time"

	"code.justin.tv/extensions/smart/services/smart/data"
	"code.justin.tv/extensions/smart/services/smart/rpc"
)

// GetMessage gets the message with sequence number x for the provided topic.
// If the message is not stored 404  is returned
func (a API) GetMessage(ctx context.Context, req *smartrpc.SingleMessageRequest) (*smartrpc.Message, error) {
	topic := req.Topic
	sequenceNumber := req.SequenceNumber
	// TODO add auth
	mes, err := a.Store.GetMessage(topicToString(topic.ChannelId, topic.ExtensionId, topic.Target), sequenceNumber)
	if err != nil {
		return messageToMessage(mes), smartrpc.NewMappedTwirpError(err.Error(), smartrpc.ErrMessageNotFound)
	}
	return messageToMessage(mes), nil
}
func messageToMessage(mes *data.Message) *smartrpc.Message {
	if mes == nil {
		return nil
	}
	return &smartrpc.Message{ContentType: mes.ContentType,
		Content: mes.Content, TimeSent: mes.TimeSent.Format(time.RFC3339),
		Sequence: &smartrpc.Sequence{Number: mes.Sequence.Number, Timestamp: mes.Sequence.Start}}
}

const topicFormat = "channel-ext-v1.%s-%s-%s"

func topicToString(channelID, extensionID, target string) string {
	return fmt.Sprintf(topicFormat, channelID, extensionID, target)
}
