package pubsub

import (
	"context"

	pubclient "code.justin.tv/chat/pubsub-go-pubclient/client"

	"code.justin.tv/extensions/smart/services/smart/data"
	"code.justin.tv/foundation/twitchclient"
	"github.com/cactus/go-statsd-client/statsd"
)

// Client expressing actions that smart needs to be able to make against PubSub
type Client interface {
	Publish(topic string, mes *data.Message) error
}

type pubsub struct {
	client pubclient.PubClient
	stats  statsd.Statter
}

// NewClient returns a new functioning PubSub client
func NewClient(stats statsd.Statter, host string) (Client, error) {
	client, err := pubclient.NewPubClient(twitchclient.ClientConf{
		Host:  host,
		Stats: stats,
	})
	return &pubsub{client, stats}, err
}

// Publish sends a message to pub sub and logs successes or failure
func (p *pubsub) Publish(topic string, mes *data.Message) error {
	bytes, err := mes.MarshalJSON()
	if err != nil {
		return err
	}
	err = p.client.Publish(context.Background(), []string{topic}, string(bytes), nil)
	if err != nil {
		_ = p.stats.Inc("pubsub.publish.failure", 1, 1)
	} else {
		_ = p.stats.Inc("pubsub.publish.success", 1, 1)
	}
	return err
}
