package validator

import (
	"context"
	"errors"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/extensions/validator/client"
)

// Client expressing actions that smart needs to be able to make against validator
type Client interface {
	CheckTokenPermission(ctx context.Context, clientID string, jwt string, channel string, verb string, targets []string, reqOpts *twitchclient.ReqOpts) error
}

// NewClient returns a functioning validator client
func NewClient(host string) (Client, error) {

	validatorClient, err := validator.NewClient(twitchclient.ClientConf{Host: host})
	if err != nil {
		return nil, errors.New("validator client not created")
	}
	return validatorClient, nil
}
