package mocks

import (
	"github.com/bradfitz/gomemcache/memcache"
)

// AlwaysFail Is for testing purposes. It simulates memcache that always fails to store
type AlwaysFail struct {
}

// Get returns no message and ErrCacheMiss. Simulates the topic not yet being stored
func (c AlwaysFail) Get(string) (*memcache.Item, error) {
	return nil, memcache.ErrCacheMiss
}

// Add always returns a error that simulates memcache failing to store
func (c AlwaysFail) Add(item *memcache.Item) error {
	return memcache.ErrNotStored
}

// CompareAndSwap always returns a error that simulates memcache failing to store
func (c AlwaysFail) CompareAndSwap(item *memcache.Item) error {
	return memcache.ErrNotStored
}
