package mocks

import (
	"github.com/bradfitz/gomemcache/memcache"
)

// GetTuple represents the items to be returned from memcache during a get
type GetTuple struct {
	Item *memcache.Item
	Err  error
}

// Variable is for testing only. It stores and returns simulated memcache responses
type Variable struct {
	GetReturns []GetTuple
	AddReturns []error
	CasReturns []error

	getCounter int
	addCounter int
	casCounter int
}

// Get returns a fake memcache response
func (c *Variable) Get(string) (*memcache.Item, error) {
	prev := c.getCounter
	c.getCounter = prev + 1
	ret := c.GetReturns[prev%len(c.GetReturns)]
	return ret.Item, ret.Err
}

// Add returns a fake memcache response
func (c *Variable) Add(item *memcache.Item) error {
	prev := c.addCounter
	c.addCounter = prev + 1
	return c.AddReturns[prev%len(c.AddReturns)]
}

// CompareAndSwap returns a fake memcache response
func (c *Variable) CompareAndSwap(item *memcache.Item) error {
	prev := c.casCounter
	c.casCounter = prev + 1
	return c.CasReturns[prev%len(c.CasReturns)]
}
