package mocks

import (
	"errors"

	"code.justin.tv/extensions/smart/services/smart/data"
)

// AlwaysFail Is for testing purposes. It simulates a Store that always fails to store
type AlwaysFail struct {
}

// GetMessage returns no message and an error indicating the message with the sequence number is not stored
func (b *AlwaysFail) GetMessage(topic string, sequenceNumber uint64) (*data.Message, error) {
	return nil, errors.New("bad Store")
}

// GetLatestMessage returns no message and an error indicating the last message is not stored
func (b *AlwaysFail) GetLatestMessage(topic string) (*data.Message, error) {
	return nil, errors.New("bad Store")
}

// SequenceMessage returns no message and an error indicating the last message was not stored
func (b *AlwaysFail) SequenceMessage(string, *data.Message) (*data.Message, error) {
	return nil, errors.New("bad Store")
}
