package discovery

import (
	"github.com/aws/aws-sdk-go/service/sns"
	"github.com/aws/aws-sdk-go/service/sns/snsiface"
)

// TopicsByDisplayName returns the SNS topic ARN that matches the
// given display name.
//
// Note this is an EXACT match, not a substring.
func TopicsByDisplayName(svc snsiface.SNSAPI, displayName string) (string, error) {
	resp, err := svc.ListTopics(&sns.ListTopicsInput{})
	if err != nil {
		return "", err
	}

	for _, topic := range resp.Topics {
		attrResp, err := svc.GetTopicAttributes(&sns.GetTopicAttributesInput{
			TopicArn: topic.TopicArn,
		})
		if err != nil {
			return "", err
		}
		if *attrResp.Attributes["DisplayName"] == displayName {
			return *topic.TopicArn, nil
		}
	}

	return "", nil
}
