# anotherone

[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=feeds/anotherone/master)](https://jenkins.internal.justin.tv/job/feeds/job/anotherone/job/master)

Include an elevator pitch summary of what your app does.


## Bootstrap of your application
Remove the bootstrap section when you're done

### Verify prereqs

1. [Docker for mac](https://download.docker.com/mac/stable/Docker.dmg) stable.
2. You *need* docker version >= 18.03.
3. [mwinit](https://w.amazon.com/index.php/NextGenMidway/UserGuide#Mac) >= 1.24 `mwinit --version` (Note: Older versions work if you're on WPA2)
4. [teleport-bastion](https://wiki.twitch.com/display/SEC/Teleport+Bastion)

### Create a new git repository

1. Visit https://git-aws.internal.justin.tv/organizations/discovery/repositories/new
2. Give it a name with all lowercase characters of length 3-12 characters. This isn't a hard requirement, but will help
the bootstrapping happen without strange issues.

### Replace your git repository with example app
```bash
# replace discovery/REPONAME with your application
cd ${GOPATH}/src/code.justin.tv/discovery
git clone git@git-aws.internal.justin.tv:discovery/REPONAME.git
cd REPONAME
git remote add anotherone git@git-aws.internal.justin.tv:feeds/anotherone.git
git fetch -av --all
git checkout -b from_example anotherone/master
```

### Modify service variables and verify them 
```bash
vim vars.sh # And edit all variables at the top, especially SERVICE=
teleport-bastion login && mwinit && ./make.sh bootstrap precheck
```

### Bootstrap everything

```bash
# turn up the speakers on your mac :)
teleport-bastion login && mwinit && ./make.sh bootstrap everything
```

### Verify everything works

1. Open https://jenkins.internal.justin.tv/job/discovery/ and click on "Scan Organization Now"
2. Visit your pipeline in Jenkins
3. Check out your code on github
4. Skip ahead to the development section below!

### Expose your service to others and optional setups

To allow other accounts to access your service, you will need to use [AWS Peering](https://wiki.twitch.com/display/SYS/AWS+VPC+Peering+at+Twitch).

To setup SSL
1. Set UseHTTPS=true in [staging.json](./cloudformation/infra/staging.json) and [production.json](./cloudformation/infra/production.json)
2. Run `./make.sh infra update staging`.  This script will eventually pause at ACM certification
3. Visit  [DNS](https://dashboard.internal.justin.tv/dns) and add the DNS entry ACM needs.  Here is an [example](https://dashboard.internal.justin.tv/dns/?entry=_902eb7c06af2fb3c9fb51adfdee3c956.staging.anotherapp.internal.justin.tv).
4. The command in step (3) will then eventually finish.

To setup Sandstorm
1. create a [role](https://dashboard.internal.justin.tv/sandstorm/manage-secrets) for your
service (both staging and production)
2. Modify [deploy.yaml](./cloudformation/deploy/deploy.yaml) to set the sandstorm ARN.
3. modify [populate_app_env](./make.sh) to set your sandstorm env variable when running code locally.

To setup S2S auth:
1. create a staging and production [S2S service](https://dashboard.internal.justin.tv/s2s/services) and
allow your task ARN.
2. Modify [deploy.yaml](./cloudformation/deploy/deploy.yaml) to set the environment variable s2s_auth
 to the name of your S2S service.
3. Modify [populate_app_env](./make.sh) to set your s2s env variable when running code locally.

### Anotherone bootcamp

You don't need to do this, but doing it could familiarize yourself with how things are setup.

#### Debug a command

Debug a make command.  Let's try a simple one, like one that formats all our go code.

```bash
DEBUG=true ./make.sh go format
```

#### Find your ALB DNS

Your ALB has an AWS given DNS name.  You can find it via the CLI.


```bash
./make.sh infra output staging anotherone:staging:LBDNS
```

#### Open a bastion shell

Go onto the bastion host inside the development environment.  From there you could curl your service's ALB.

```bash
> ./make.sh bastion execute
Last login: Wed Nov  7 20:01:33 2018 from 10.204.93.204

       __|  __|_  )
       _|  (     /   Amazon Linux 2 AMI
      ___|\___|___|

https://aws.amazon.com/amazon-linux-2/
4 package(s) needed for security, out of 16 available
Run "sudo yum update" to apply all updates. 
[jlindamo@ip-10-204-94-154 ~]$ curl internal-anotherone-staging-ALB-668710864.us-west-2.elb.amazonaws.com
404 page not found
```


#### Bastion shell directly

You can chain these two commands to curl your ALB directly

```bash
./make.sh bastion execute curl -s $(./make.sh infra output staging anotherone:staging:LBDNS | tr -d '\r' )/_health/anotherone
```

#### Customize the builder

Add a custom binary to the builder.  Let's use ruby.  Modify [the builder](./builder/Dockerfile) and
add a ruby installation to the apt-get command.

```bash
   # For protoc install
   unzip=6.0\* \
+  # For ruby
+  ruby=1:2\*  
   # For aws-cli
   python-setuptools=33.1\* python-pip=9.0\* \
```

Now modify [vars.sh](./vars.sh) to signal you have a new version of the builder.

```bash
BUILDER_TAG=${SERVICE}-builder:builder-666 # Or whatever is the next number
```

Now build and push this new builder

```bash
./make.sh builder make
./make.sh builder push
```

#### Add your own make command

Modify [make.sh](./make.sh) and add a bash function that now uses ruby.

```bash
function root__sayhi() {
  if [ "${1-}" == "help" ]; then
    echo "Say hello to the user"
    exit 0
  fi
  if [ "${USE_BUILDER}" == "true" ]; then
    make_exec builder run sayhi $@
  fi
  ruby -e "puts 'Hello from ruby'"
}
```

Now run your new command.  Since USE_BUILDER is the default, it should run inside your
docker builder.

```bash
> ./make.sh sayhi
Hello from ruby
```

#### Try skipping the docker container

If you have ruby on your mac, try skipping the docker container.  This may or may not work

```bash
> USE_BUILDER=false ./make.sh sayhi
Hello from ruby
```

#### Put your make command inside the pipeline

Modify [Jenkinsfile](./Jenkinsfile) and add a stage for your custom command.  I suggest right after stage("Lint").

```groovy
   stage("Lint") {
     steps {
       sh './make.sh go lint'
       sh './make.sh docker lint cmd/anotherone/Dockerfile cmd/anotherone/Dockerfile_integration_test builder/Dockerfile'
     }
   }
+  stage("Talk") {
+    steps {
+      sh './make.sh sayhi'
+    }
+  }
```

Push your modification to a new branch:

```bash
git commit -am 'Testing stuff'
git push origin HEAD:testing_jenkins
```

[Visit your build pipeline](https://jenkins.internal.justin.tv/job/feeds/job/anotherone/job/testing_jenkins/) and watch it run your custom step

#### Remove existing make commands

Modify [make.sh](./make.sh) and remove the default make command for the bootstrapping.

```bash
unset -f root__bootstrap
``` 

Now try running bootstraps and it should fail

```bash
> ./make.sh bootstrap
Undefined subcommand bootstrap
```

#### Run the app without using Docker

You can try running your application without using Docker.  This may decrease start-up time since docker for mac's file
system driver is very slow.

```bash
< USE_BUILDER=false ./make.sh go run
```

## Anotherone's big table of links

| Thing | Link |
|-------------|-----|
| Staging endpoint | http://www.staging.anotherone.internal.justin.tv |
| Production endpoint | http://www.production.anotherone.internal.justin.tv |
| Grafana dashboard | https://grafana.internal.justin.tv/dashboard/db/anotherone |
| Alerting (also via grafana) | https://grafana.internal.justin.tv/dashboard/db/anotherone |
| Source code | https://git-aws.internal.justin.tv/feeds/anotherone |
| Code build | https://jenkins.internal.justin.tv/job/feeds/job/anotherone/job/master |
| Dev AWS account | https://isengard.amazon.com/account/226965686091 |
| Production AWS account | https://isengard.amazon.com/account/393910000642 |
| Build deployment | https://jenkins.internal.justin.tv/job/feeds/job/anotherone/job/master |
| Container logs (staging) | https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logStream:group=anotherone-staging-ECSLogGroup |
| Container logs (production) | https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logStream:group=anotherone-production-ECSLogGroup |
| Secrets management | https://dashboard.internal.justin.tv/sandstorm/manage-secrets?nameFilter=anotherone |
| Staging DNS management | https://dashboard.internal.justin.tv/dns/?entry=www.staging.anotherone.internal.justin.tv |
| Production DNS management | https://dashboard.internal.justin.tv/dns/?entry=www.production.anotherone.internal.justin.tv |
| Error logs (staging) | https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logStream:group=anotherone-staging-ECSLogGroup |
| Error logs (production) | https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logStream:group=anotherone-production-ECSLogGroup |
| Slack channel | [#anotherone](https://twitch.slack.com/messages/anotherone) |
| Staging infra cloudformation | https://us-west-2.console.aws.amazon.com/cloudformation/home?region=us-west-2#/stack/detail?stackId=anotherone-staging-infra |
| Staging deploy cloudformation | https://us-west-2.console.aws.amazon.com/cloudformation/home?region=us-west-2#/stack/detail?stackId=anotherone-staging-deploy |
| Oncall rotation | https://twitchoncall.pagerduty.com/services/PAKT4XA |


## Development

### Verify prereqs

1. [Docker for mac](https://download.docker.com/mac/stable/Docker.dmg) stable.
2. You *need* docker version >= 18.03.
3. [mwinit](https://w.amazon.com/index.php/NextGenMidway/UserGuide#Mac) >= 1.24 `mwinit --version`
4. [teleport-bastion](https://wiki.twitch.com/display/SEC/Teleport+Bastion)

### Verify your setup is ready for development

```bash
# Run this in one terminal
./make.sh bastion tunnel
# Run this in *ANOTHER* terminal
./make.sh extra ok_for_development
```

### Write some code

Write code and make changes.  Feel free to push your changes to jenkins in a
branch to verify lints/checks.

### Run your application locally

```bash
./make.sh go run
```

### Check locally your code works

It's ok to offload this to a jenkins branch during normal development, but you
should verify at least once you can check your code locally.

```bash
./make.sh go lint
./make.sh go test
./make.sh go integration_test
./make.sh docker build
```

### Submit pull request to github and wait for review
```bash
git push origin HEAD:pull_request
# Create pull request on https://git-aws.internal.justin.tv/feeds/anotherone
```

### Merge to master to deploy 

Deployment is controlled via [Jenkinsfile](./Jenkinsfile).  Every push to master will run the deployment pipeline and
auto deploy to staging.  Manual confirmation is required for canary then production pushes.

If there is an emergency, pushes to `emergency_production_push` will skip all test checks
and push as quickly to possible to production.

### Code revert

To revert a code deploy, push a revert git commit to master.  If you can't wait that long, push a reverted commit
to `emergency_production_push`, which will revert as quickly as possible.

### Code profile

If you have go >= 1.11 installed locally, you can profile the service on port 6060.  A simple helper exists
to profile a random host in a ECS cluster.

```bash
# Requires teleport-bastion socks proxy running in the background
# If it hangs, stop and restart your tunnel
./make.sh ecs go_dump_profile staging
```

## Operation

This section includes operational tasks that an on-call would want to do for the service.  It should also include
a section on how to debug the service (Go here, try this, look for this, etc).

