package httpapi

import (
	"net/http"

	"code.justin.tv/feeds/anotherone/proto/anotherone"
	"code.justin.tv/hygienic/basehttpserver"
	"code.justin.tv/sse/malachai/pkg/s2s/callee"
)

// HTTPServer exposes our twirp service
type HTTPServer struct {
	basehttpserver.HTTPServer
	AnotheroneServer anotherone.TwirpServer
	S2SClient        *callee.Client
}

// Setup registers all the HTTPHandlers on the server's mux
func (h *HTTPServer) Setup() error {
	handler := http.Handler(h.AnotheroneServer)
	if h.S2SClient != nil {
		handler = h.S2SClient.RequestValidatorMiddleware(h.AnotheroneServer)
	}
	h.Mux.Handle(anotherone.AnotheronePathPrefix, handler)
	return h.HTTPServer.Setup()
}
