#!/bin/bash
# For help, run ./make.sh
set -euo pipefail
. vars.sh
. ./scripts/jenkins_cf_deployer/all.sh

# Populate environment variables you app needs to execute. This is only used
# when running your code locally.
function populate_app_env() {
  INFRA=${INFRA-staging}
  export anotheronesecret=abc
  export ENVIRONMENT=development
  export ITEM_GET_TABLE=${ITEM_GET_TABLE-$(cached_cloudformation_output ${SERVICE}:${INFRA}:ItemGetTable)}
  [ ! -z ${ITEM_GET_TABLE} ]
  export REDIS_HOST=${REDIS_HOST-$(        cached_cloudformation_output ${SERVICE}:${INFRA}:RedisHost)}
  [ ! -z ${REDIS_HOST} ]
  export SANDSTORM_ARN_FIXME="_EMPTY_"
  # TODO: Add note about where this exists and why
#  export SANDSTORM_ARN=${SANDSTORM_ARN-$(  cached_cloudformation_output ${SERVICE}:${INFRA}:SandstormARN)}
#  [ ! -z ${SANDSTORM_ARN} ]
}

# Uncomment this when you're done setting up to remove bootstrapping from your build processing
#unset -f root__bootstrap
process_build root__ $@
