#!/bin/bash


#### VERIFY ALL OF THESE VARIABLES ARE CORRECT

######################################## There is a 99% chance you have to change everything in this section
REPO=code.justin.tv/feeds/anotherone
# The name of your service should *PROBABLY* be your repository name
export SERVICE=anotherone

# These variables do not need to be directly exposed to subcommands so they are not 'export'
# Your dev account should have a teleport bastion: https://wiki.twitch.com/display/SEC/Teleport+Bastion
# This is the name of your bastion setup
BASTION_ENV=twitch-category-db-dev
# Your ops pipeline and your prod account can probably be the same account ID
OPS_PIPELINE_ACCOUNT_ID=393910000642
PROD_ACCOUNT_ID=393910000642
# This is your dev account's ID
DEV_ACCOUNT_ID=226965686091
# This is the name of your CLI profile the Jenkins pipeline should assume.  You should already have a jenkins limited
# user setup: https://git-aws.internal.justin.tv/twitch/jenkins_cf_user and have uploaded to Jenkins the created
# credentials file.  This is the name of the profile inside that file.
# For example, if the file is
# [blarg-zz]
#   SECRET=ABC
#   TOKEN=RRY
# Then this value would be blarg-zz
OPS_PIPELINE_PROFILE=twitch-category-db-prod



######################################## There is a 10% chance you have to change anything in this section

# You should already have roles in isengard for your account and your user should be in those roles
# http://isengard.amazon.com/
# This is the role you can give developers.  Since it's in another account, even admin cannot hurt your production pipeline
DEV_ISENGARD_ROLE=admin

# These are the roles that allow modification of production
PROD_ISENGARD_ROLE=admin
OPS_PIPELINE_ROLE=admin

# You can leave this as-is.  You only need to change this when you change your builder
BUILDER_TAG=${SERVICE}-builder:builder-12

######################################## There is a 1% chance you have to change anything in this section
#### YOU PROBABLY DO NOT NEED TO CHANGE ANYTHING BELOW THIS LINE, BUT YOU CAN IF YOU NEED TO

# The newest aws-cli uses AWS_DEFAULT_REGION (https://docs.aws.amazon.com/cli/latest/userguide/cli-environment.html)
# The go sdk uses AWS_REGION (https://github.com/aws/aws-sdk-go/issues/2103)
export AWS_DEFAULT_REGION=${DEFAULT_AWS_REGION-us-west-2}
export AWS_REGION=${AWS_DEFAULT_REGION}
LOCAL_GO_RUN_DOCKER_ARGS="-p 8080:8080 -p 6060:6060"

# This role should also have cloudformation output reading permissions so it can populate env variables
LOCAL_DEV_ROLE="arn:aws:iam::${DEV_ACCOUNT_ID}:role/${SERVICE}-staging-task-role"
# Pipeline role is the master control role.  It assumes the deploy roles to do deployments
PIPELINE_RUNNING_ROLE="arn:aws:iam::${OPS_PIPELINE_ACCOUNT_ID}:role/${SERVICE}-pipeline"
DEV_DEPLOY_ROLE="arn:aws:iam::${DEV_ACCOUNT_ID}:role/${SERVICE}-staging-ops-deployer"
PROD_DEPLOY_ROLE="arn:aws:iam::${PROD_ACCOUNT_ID}:role/${SERVICE}-production-ops-deployer"
BUILDER=${OPS_PIPELINE_ACCOUNT_ID}.dkr.ecr.${AWS_DEFAULT_REGION}.amazonaws.com/${BUILDER_TAG}
INT_TEST_EXEC_ROLE=arn:aws:iam::${DEV_ACCOUNT_ID}:role/${SERVICE}-staging-task-exec-role
INTEGRATION_TEST_TIMEOUT=${INTEGRATION_TEST_TIMEOUT-3m}
# You can set this to false to run commands locally and not inside the builder
export USE_BUILDER=${USE_BUILDER-true}
export GIT_COMMIT=${GIT_COMMIT-$(git rev-parse --verify HEAD)}
# Ah the magic token (yes, this *just works*)
export CODECOV_TOKEN=ghe



######################################### You can leave these as "GUESS" if you like and we will try to guess them
######################################### during bootstrap.  Once bootstrapped, you can remove all of these variables
######################################### If we cannot guess any, set them to something besides GUESS

#### TODO: Delete all of this after bootstrapping
STAGING_VPC_ID="GUESS"                      # Should be something like vpc-0c80c8305e3dd2f63
STAGING_SECURITY_GROUP="GUESS"              # Should be something like sg-09f622ede10078f9a
STAGING_SUBNETS="GUESS"                     # Should be something like subnet-0dd0da31a5dc54686,subnet-0c9feb00bd983ffa1,subnet-06629078b5e685ac0

PROD_VPC_ID="GUESS"
PROD_SECURITY_GROUP="GUESS"
PROD_SUBNETS="GUESS"
