import { PostBox } from 'brickie/components/post';
import { FeedResponse, Post } from 'brickie/models/feed';
import { object } from 'prop-types';
import * as React from 'react';
import JSONTree from 'react-json-tree';

interface FeedProps {
  userID: string;
  feed?: FeedResponse | null;
  feedID: string;
  onChange: () => void;
}

export const FeedComponent: React.StatelessComponent<FeedProps> = (props: FeedProps, context) => {
  const removePostClick = (post: Post) => {
    context.masonry.removePost(props.feedID, post.debug.source.entity).then(() =>
      props.onChange(),
    );
  };
  if (!props.userID) {
    return <div>No user ID selected</div>;
  }
  if (!props.feed) {
    return <div>No feed found</div>;
  }
  let posts = [];
  if (props.feed.posts) {
    for (let i = 0; i < props.feed.posts.length; i++) {
      let removeButton = <div />;
      if (props.feedID) {
        removeButton = <button onClick={removePostClick.bind(null, props.feed.posts[i])}>Remove Post</button>;
      }
      posts.push(
        <div key={i}>
          {removeButton}
          <PostBox Post={props.feed.posts[i]}/>
        </div>,
      );
    }
  }

  return(
    <div>
      Feed ID: {props.feedID}
      {posts}
      {props.feed && <JSONTree data={props.feed} />}
    </div>
  );
};

FeedComponent.contextTypes = {
  masonry: object,
};
