import * as React from 'react';

import { Feed } from 'brickie/components/feed';
import { UserSelector } from 'brickie/components/user';

interface ShowUserFeedProps {
}

interface ShowUserFeedState {
  userID: string;
}

export class ShowUserFeed extends React.Component<ShowUserFeedProps, ShowUserFeedState> {
  constructor(props: ShowUserFeedProps) {
    super(props);
    this.state = {
      userID: '',
    };
  }

  public render() {
    let f = (newUserID: string) => {
      this.setState({ userID: newUserID });
    };
    return (
      <div>
        <UserSelector onUserID={f}/>
        <Feed userID={this.state.userID}/>
      </div>
    );
  }
}
