import * as React from 'react';

import { object } from 'prop-types';

import { FeedsEdgeClient } from 'brickie/core/clients/feeds-edge';
import { MasonryClient } from 'brickie/core/clients/masonry';
import { UsersClient } from 'brickie/core/clients/users';
import { Config } from 'brickie/core/config/config';

export interface ApiClientContext {
  feedsEdge: FeedsEdgeClient;
  users: UsersClient;
  masonry: MasonryClient;
}

interface ApiProviderProps {
  config: Config;
}

export class ApiProvider extends React.Component<ApiProviderProps, {}> {
  public static childContextTypes = {
    feedsEdge: object,
    users: object,
    masonry: object,
  };

  private feedsEdgeClient: FeedsEdgeClient;
  private usersClient: UsersClient;
  private masonryClient: MasonryClient;

  constructor (props: ApiProviderProps) {
    super(props);
    this.feedsEdgeClient = new FeedsEdgeClient(props.config);
    this.usersClient = new UsersClient(props.config);
    this.masonryClient = new MasonryClient(props.config);
  }

  public getChildContext(): ApiClientContext {
    return {
      feedsEdge: this.feedsEdgeClient,
      users: this.usersClient,
      masonry: this.masonryClient,
    };
  }

  public render() {
    return (
      <div>{this.props.children}</div>
    );
  }
}
