import * as React from 'react';
import * as ReactDOM from 'react-dom';

import './style.sass';

import { ApiProvider } from 'brickie/core/api-provider';
import { Config } from 'brickie/core/config/config';
import createHistory from 'history/createBrowserHistory';
import {
  NavLink,
  Route,
  Router,
} from 'react-router-dom';

import { Front } from 'brickie/pages/front';

export class Brickie {
  constructor (config: Config) {
    let container = document.createElement('div');
    let history = createHistory();
    document.body.appendChild(container);

    ReactDOM.render(
      <Router history={history}>
        <ApiProvider config={config}>
          <div>
            <nav>
              <ul>
                <li><NavLink to="/">Front</NavLink></li>
              </ul>
            </nav>

            <Route exact path="/" component={Front} />
          </div>
        </ApiProvider>
      </Router>,
      container,
    );
  }
}
