import { Config } from 'brickie/core/config/config';

export class FeedsEdgeClient {
  private baseURL: string;

  constructor(config: Config) {
    this.baseURL = config.feedsEdgeURL;
  }

  public getFeed(feedID: string) {
    let url = `${this.baseURL}/v1/feeds/${feedID}`;
    return fetch(url, {
      method: 'GET',
      headers: {
        'X-Ctxlog-Elevate': 'true',
      },
    }).then((resp) => ( resp.json() ));
  }
}
