import { Config } from 'brickie/core/config/config';

export class MasonryClient {
  private baseURL: string;

  constructor(config: Config) {
    this.baseURL = config.masonryURL;
  }

  public removePost(feedID: string, entityID: string) {
    const url = `${this.baseURL}/v1/story/${feedID}/${entityID}`;
    return fetch(url, {
      method: 'DELETE',
    });
  }
}
