import { Config } from 'brickie/core/config/config';
import { KrakenUsers, User } from 'brickie/models/users';

export class UsersClient {
  private baseURL: string;
  private clientID: string;

  constructor(config: Config) {
    this.baseURL = config.visageURL;
    this.clientID = config.clientID;
  }

  public getUserFromID(userID: string): Promise<User> {
    let requestURL = `${this.baseURL}/kraken/users/${userID}`;
    let options = {
      headers: {
        'Client-ID': this.clientID,
        'Accept': 'application/vnd.twitchtv.v5+json',
      },
    };

    return fetch(requestURL, options).then((resp) => (resp.json()));
  }

  public getUserFromLogin(userLogin: string): Promise<User | null> {
    let requestURL = `${this.baseURL}/kraken/users?login=${userLogin}`;
    let options = {
      headers: {
        'Client-ID': this.clientID,
        'Accept': 'application/vnd.twitchtv.v5+json',
      },
    };

    return fetch(requestURL, options)
    .then((resp) => ( resp.json() ))
    .then((visageUsers: KrakenUsers): User | null => {
      if (visageUsers._total === 1) {
        return visageUsers.users[0];
      } else {
        return null;
      }
    });
  }
}
