export interface FeedResponse {
  cursor: string;
  posts: Array<Post>;
}

export interface Post {
  id: string;
  created_at: string;
  user_id: string;
  body: string;
  emotes: Array<Emote>;
  embeds: Array<Embed>;
  permissions: PostPermissions;
  comments: Comments;
  reactions: Reactions;
  share_summary: ShareSummary;
  reasons: Array<Reason>;
  debug: PostDebugInfo;
}

export interface PostDebugInfo {
  source: Activity;
}

export interface Activity {
  entity: string;
  verb: string;
  actor: string;
}

export interface Emote {
  id: number;
  start: number;
  end: number;
  set: number;
}

export interface Embed {
  request_url: string;
  type: string;
  title: string;
  author_name: string;
  thumbnail_url: string;
  player_html: string;
  provider_name: string;
}

export interface PostPermissions {
  can_reply: boolean;
  can_delete: boolean;
  can_moderate: boolean;
  can_reply_reason: string;
}

export interface Comments {
  total: number;
  cursor: string;
  comments: Array<Comment>;
}

export interface Comment {
  id: string;
  user_id: string;
  body: string;
  parent_entity: string;
  created_at: string;
  needs_approval: boolean;
  emotes: Array<Emote>;
  permissions: CommentPermissions;
  reactions: Reactions;
}

export interface CommentPermissions {
  can_delete: boolean;
}

export interface Reactions {
  [emoteID: string]: ReactionEmote;
}

export interface ReactionEmote {
  emote: string;
  count: number;
  user_ids: Array<string>;
}

export interface ShareSummary {
  user_ids: Array<string>;
  share_count: number;
}

export interface Reason {
  type: string;
  user_id: string;
  created_at: string;
}
