package ctxloggoji

import (
	"net/http"

	"code.justin.tv/feeds/ctxlog"
)

// GojiMiddleware is usable by goji.Use  Will log the request as well as inject the needed headers
func GojiMiddleware(Ctxlog *ctxlog.Ctxlog, logger ctxlog.Logger) func(h http.Handler) http.Handler {
	return func(h http.Handler) http.Handler {
		return &ctxlog.CtxHandler{
			Next:   h,
			Ctxlog: Ctxlog,
			Logger: logger,
		}
	}
}
