#!/usr/bin/env node

const _ = require('lodash');
const util = require('util');
const DuploDataValidation = require('./ddv');
const config = require('./config');

function inspect (val) {
    return util.inspect(val, {showHidden: true, depth: null, colors: process.env.CLICOLOR});
}

let ddv = new DuploDataValidation(config)
ddv
    .validate()
    .then(ress => {
        let isAllValid = ress.reduce((isValid, {type, invalid}) => {
            let isTypeValid = !invalid.length;
            console.log(type, isTypeValid ? "valid" : "invalid:");
            if (!isTypeValid) console.error(inspect(invalid));
            return isValid && isTypeValid;
        }, true);
        if (!isAllValid) console.error("data was invalid!");
        return isAllValid ? 0 : 1;
    })
    .catch(err => {
        let errObj = err || {};
        console.error(errObj.stack || err || "unknown error");
        if (errObj.invalid) {
            console.error(inspect(ddv.audreyGUIDCache));
            console.error(inspect(errObj.invalid));
        }
        return 126;
    })
    .then(code => process.exit(code));
