# duplo
Service to store the building blocks of feeds.  Posts, comments, and reactions

## Development


To get started with development, run the following:

```
make setup # This sets up lint and code formatting
make run   # This runs the server
```

For making sure that unit tests pass during development, run

```
go get github.com/smartystreets/goconvey
goconvey
```

To run integration tests you will need an account on twitch-feed-dev and
have it set up in your local AWS credentials file

```
AWS_PROFILE=twich-feed-dev make integration_test_cover
```

Lastly, before you commit your changes you should run

```
make precommit
```

Which will reformat your code and run the linter

## Re-vendoring Dependencies

Clear the glide cache

```
glide cc
```

Updates vendor directory (and removes nested vendor directories)

```
glide up -v
```

Remove unused files in vendored dependencies

```
glide-vc --only-code --no-tests --use-lock-file --keep **/*.mk
```
