package dupdynamo

import (
	"testing"

	"code.justin.tv/feeds/feeds-common/entity"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	. "github.com/smartystreets/goconvey/convey"
)

func TestIdStructCursor(t *testing.T) {
	Convey("idEncoder should encode correctly", t, func() {
		i := userIDCreatedAtKeyEncoder{}
		str, err := i.encode(map[string]*dynamodb.AttributeValue{
			"id": {
				S: aws.String("123"),
			},
			"created_at": {
				N: aws.String("1469836385390047000"),
			},
		})
		So(err, ShouldBeNil)
		So(str, ShouldContainSubstring, str)
		vals, err := i.decode(str)
		So(err, ShouldBeNil)
		So(*vals["id"].S, ShouldEqual, "123")
		So(*vals["created_at"].N, ShouldEqual, "1469836385390047000")
	})
}

func TestUniqueEnts(t *testing.T) {
	e1 := entity.New("a", "b")
	e2 := entity.New("a", "b")
	e3 := entity.New("a", "c")
	e := uniqueEnts([]entity.Entity{e1, e2, e3})
	if len(e) != 2 {
		t.Errorf("Invalid entity length")
	}
}
