package db

import (
	"testing"

	"code.justin.tv/feeds/feeds-common/entity"
	. "github.com/smartystreets/goconvey/convey"
)

func TestModelStrings(t *testing.T) {
	Convey("Models should have reasonable string methods", t, func() {
		p := Post{ID: "hi"}
		c := Comment{ID: "hi"}
		r := Reactions{UserID: "hi"}
		s := ReactionsSummary{ParentEntity: entity.New("test", "hi")}
		type canString interface {
			String() string
		}
		arr := []canString{
			&p, &c, &r, &s,
		}
		for _, a := range arr {
			So(a.String(), ShouldContainSubstring, "hi")
		}
	})
}
