// +build integration

package main

import (
	"net/http"
	"os"
	"os/exec"
	"path/filepath"
	"testing"
)

func testClientIntegrationAllClientTests(t *testing.T, ts *testSetup) {
	resp, err := http.Get(ts.host + "/debug/running")
	if err != nil {
		t.Error(err)
	}
	if resp.StatusCode != http.StatusOK {
		t.Error("Unable to verify the server is running")
	}
	cmd := exec.Command("/bin/bash", "-c", "make duplo_integration_test")
	cmd.Env = append(os.Environ(), []string{
		"client_int_tests_duplo.http_endpoint=" + ts.host,
	}...)
	cwd, err := os.Getwd()
	if err != nil {
		t.Error(err)
	}
	cmd.Dir, err = filepath.Abs(cwd + "../../../../clients")
	if err != nil {
		t.Error(err)
	}
	if _, err := os.Stat(cmd.Dir); os.IsNotExist(err) {
		t.Log("client directory does not exist.  Skipping a test", cmd.Dir)
		return
	}
	cmd.Stdout = os.Stdout
	cmd.Stderr = os.Stderr
	t.Log("Starting the run")
	if err := cmd.Run(); err != nil {
		t.Error(err)
	}
	t.Log("Run finished")
}
