freeStyleJob('feeds-duplo') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'feeds/duplo', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell './jenkins.sh'
    conditionalSteps {
      condition {
        shell 'test $GIT_BRANCH = "origin/master" && ./vendor/code.justin.tv/twitch/ecs-deploy/helpers/is-new-deploy.sh feeds duplo $GIT_COMMIT'
      }
      runner('DontRun')
      steps {
        downstreamParameterized {
          trigger('feeds-duplo-pipeline') {
            parameters {
              predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
            }
          }
        }
      }
    }
  }
}
