#!/bin/bash
set -ex
env
SERVICE="duplo"
if [ -z "$AWS_CONFIG_FILE" ]; then
	CREDS="-v $HOME/.aws:/root/.aws:ro"
else
	CREDS="-e AWS_SHARED_CREDENTIALS_FILE=/awsconfig -v $AWS_CONFIG_FILE:/awsconfig:ro -e duplo_aws.assume_role=arn:aws:iam::724951484461:role/feeds-duplo-integration"
fi
docker run -w /go/src/code.justin.tv/feeds/$SERVICE $CREDS  -v `pwd`:/go/src/code.justin.tv/feeds/$SERVICE docker.internal.justin.tv/hygienic/gobuilder:1.10.1-0 make jenkins
if [ -z "$GIT_COMMIT" ]; then
  GIT_COMMIT=$(git rev-parse --verify HEAD)-$(whoami)
fi
./vendor/code.justin.tv/twitch/ecs-deploy/helpers/build-tag-push.sh feeds $SERVICE $GIT_COMMIT ./cmd/duplo/Dockerfile
