locals {
  service = "duplo"

  sandstorm_role_arns = {
    integration = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-integration"
    staging     = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-staging"
    canary      = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
    production  = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
  }

  sandstorm_role_arn = "${lookup(local.sandstorm_role_arns, var.environment)}"
}

variable environment {}
variable iam_id {}

// TODO: Restrict to only the correct dynamodb tables
resource "aws_iam_role_policy" "dynamodb_policy" {
  name = "${local.service}_${var.environment}_policy"
  role = "${var.iam_id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "dynamodb:*"
      ],
      "Resource": [
        "*"
      ]
    },
    {
      "Effect": "Allow",
      "Action": [
        "sns:*"
      ],
      "Resource": [
        "*"
      ]
    },
    {
      "Action": "sts:AssumeRole",
      "Resource": [
        "${local.sandstorm_role_arn}"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}

# TODO: Restrict resource to only the fanout input queue
resource "aws_iam_role_policy" "sqs_policy" {
  name = "sqs_policy_${local.service}_${var.environment}"
  role = "${var.iam_id}"

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Sid": "Stmt1471373292000",
            "Effect": "Allow",
            "Action": [
                "sqs:SendMessage"
            ],
            "Resource": [
                "*"
            ]
        }
    ]
}
EOF
}
