package verb

import "errors"

// Verb is the action for a given activity
type Verb string

const (
	// Create is when something is created
	Create = Verb("create")
	// Update is when something is updated
	Update = Verb("update")
	// Delete is when something is deleted
	Delete = Verb("delete")
)

// FromString takes a string and returns the verb that it represents.
func FromString(value string) (Verb, error) {
	if value == "" {
		return Verb(""), errors.New("verb: invalid verb " + value)
	}
	return Verb(value), nil
}
