package statsdim

import (
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestStatsdToDimensions(t *testing.T) {
	Convey("base case", t, func() {
		s := ConfigurableDelimiterMetricDeconstructor{
			MetricRules: []*ConfigurableDelimiterMetricRule{
				{
					MetricPath:    "go.*",
					DimensionsMap: "lang.%",
				},
				{
					MetricPath:    "go.*.*",
					DimensionsMap: "lang.%.%",
				},
				{
					MetricPath:    "go",
					DimensionsMap: "lang",
					MetricName:    "_ignored_",
				},
			},
		}
		So(DelimiterLoader(&s), ShouldBeNil)

		trans := StatsdTranslator{
			GaugeTranslator: s,
			Prefix:          "",
		}
		Convey("just find go", func() {
			_, d, err := s.Parse("go")
			So(err, ShouldBeNil)
			So(d, ShouldResemble, map[string]string{"lang": "go"})
		})
		Convey("prefix on go", func() {
			substat := trans.NewSubStatter("go")
			So(substat, ShouldNotBeNil)
			metricName, dims, err := substat.Gauge("num_goroutines")
			So(metricName, ShouldEqual, "num_goroutines")
			So(dims, ShouldResemble, map[string]string{"lang": "go"})
			So(err, ShouldBeNil)
		})
		Convey("basic case", func() {
			m, d, err := s.Parse("go.num_goroutines")
			So(err, ShouldBeNil)
			So(m, ShouldEqual, "num_goroutines")
			So(d, ShouldResemble, map[string]string{"lang": "go"})

			metricName, dims, err := trans.Gauge("go.num_goroutines")
			So(metricName, ShouldEqual, "num_goroutines")
			So(dims, ShouldResemble, map[string]string{"lang": "go"})
			So(err, ShouldBeNil)
		})
		Convey("with dots", func() {
			m, d, err := s.Parse("go.gc.parts")
			So(err, ShouldBeNil)
			So(d, ShouldResemble, map[string]string{"lang": "go"})
			So(m, ShouldEqual, "gc.parts")
		})
		Convey("unknown roots", func() {
			_, _, err := s.Parse("another.root")
			So(err, ShouldNotBeNil)
		})
	})
}
