package ondemand

import (
	"encoding/json"
	"sync"

	"code.justin.tv/feeds/errors"
	"github.com/hashicorp/consul/api"
)

type DeployDB struct {
	kv     *api.KV
	kvErr  error
	onceKv sync.Once
}

type deploymentInfo struct {
	DeployAWSRole string            `json:"deploy_aws_role,omitempty"`
	AWSCreds      string            `json:"aws_creds,omitempty"`
	Region        string            `json:"region,omitempty"`
	PromoteFrom   string            `json:"promote_from,omitempty"`
	AutoPromote   bool              `json:"auto_promote,omitempty"`
	Profile       string            `json:"profile,omitempty"`
	TaskTemplate  string            `json:"task_template,omitempty"`
	Data          map[string]string `json:"data,omitempty"`
	ClusterName   string            `json:"cluster_name,omitempty"`
	ServiceName   string            `json:"service_name,omitempty"`
}

type terraformStateRemote struct {
	Region string `json:"region,omitempty"`
	Bucket string `json:"bucket,omitempty"`
	Key    string `json:"key,omitempty"`
}

func (d *DeployDB) createConsulClient() (*api.KV, error) {
	d.onceKv.Do(func() {
		config := api.DefaultConfig()
		config.Address = "consul.internal.justin.tv"
		config.Datacenter = "us-west2"

		client, err := api.NewClient(config)
		if err != nil {
			d.kvErr = err
			return
		}
		d.kv = client.KV()
	})
	return d.kv, d.kvErr
}

func (d *DeployDB) getDeploymentInfo(team string, service string, env string) (*deploymentInfo, error) {
	kv, err := d.createConsulClient()
	if err != nil {
		return nil, err
	}
	key := "pipeline/info/" + team + "/" + service + "/" + env
	p, _, err := kv.Get(key, nil)
	if err != nil {
		return nil, err
	}
	if p == nil {
		return nil, errors.Errorf("unable to find consul key %s", key)
	}
	var ret deploymentInfo
	if err := json.Unmarshal(p.Value, &ret); err != nil {
		return nil, err
	}
	return &ret, nil
}

func (d *DeployDB) deployedVersion(team string, service string, env string) (string, error) {
	return "", nil
}
