package ondemand

import (
	"fmt"
	"net/http"

	"code.justin.tv/feeds/errors"
)

type DockerHelper struct {
	DockerHost string
	HTTPClient http.Client
}

func (d *DockerHelper) dockerImageExists(team string, service string, tag string) error {
	httpEndpoint := fmt.Sprintf("https://%s/v2/%s/%s/manifests/%s", d.DockerHost, team, service, tag)
	fmt.Println(httpEndpoint)
	req, err := http.NewRequest(http.MethodGet, httpEndpoint, nil)
	if err != nil {
		return err
	}
	client := http.Client{}
	resp, err := client.Do(req)
	if err != nil {
		return err
	}
	if resp.StatusCode == http.StatusNotFound {
		return errors.Errorf("MISSING image %s/%s:%s", team, service, tag)
	}
	if resp.StatusCode == http.StatusOK {
		return nil
	}
	return errors.Errorf("Unexpected status code %d", resp.StatusCode)
}
