package ondemand

import (
	"html/template"

	"github.com/aws/aws-sdk-go/service/ecs"
)

type ListTasksData struct {
	Tasks []*RunningTask
}

const listTasksTemplateText = `<html>
	<body>
		<table border="1">
		  <tr>
			<th>ID</th>
			<th>Team</th>
			<th>Service</th>
			<th>Image Name</th>
			<th>Version</th>
			<th>ForwardHost</th>
			<th>ForwardPort</th>
			<th>CreationTime</th>
			<th>UpdateTime</th>
		  </tr>
			{{ range $key, $value := .Tasks -}}
		  <tr>
			<td> <a href="/task/{{ $value.DynamoID }}"> {{ $value.DynamoID }} </a> </td>
            <td> {{ $value.Team }} </td>
			<td> {{ $value.Service }} </td>
			<td> {{ $value.ImageName }} </td>
			<td> {{ $value.Version }} </td>
			<td> {{ $value.ForwardHost }} </td>
			<td> {{ $value.ForwardPort }} </td>
			<td> {{ $value.CreationTime }} </td>
			<td> {{ $value.UpdateTime }} </td>
		  </tr>
			{{ end -}}
		</table>
	</body>
</html>`

var listTasksTemplate = template.Must(template.New("list_tasks_template").Parse(listTasksTemplateText))

type ShowTaskData struct {
	Task    *RunningTask
	ECSTask *ecs.Task
}

const showTaskText = `<html>
	<body>
		<table border="1">
		  <tr>
			<th>ID</th>
			<th>Team</th>
			<th>Service</th>
			<th>Image Name</th>
			<th>Version</th>
			<th>ForwardHost</th>
			<th>ForwardPort</th>
			<th>CreationTime</th>
			<th>UpdateTime</th>
		  </tr>
		  <tr>
			<td> <a href="/task/{{ .Task.DynamoID }}"> {{ .Task.DynamoID }} </a> </td>
            <td> {{ .Task.Team }} </td>
			<td> {{ .Task.Service }} </td>
			<td> {{ .Task.ImageName }} </td>
			<td> {{ .Task.Version }} </td>
			<td> {{ .Task.ForwardHost }} </td>
			<td> {{ .Task.ForwardPort }} </td>
			<td> {{ .Task.CreationTime }} </td>
			<td> {{ .Task.UpdateTime }} </td>
		  </tr>
		</table>

        <h2>Task Cluster:</h2>
		<p> {{ .Task.TaskCluster }} </p>

        <h2>Task ARN:</h2>
		<p> {{ .Task.TaskARN }} </p>

		<h2> ECS task description </h2>
			<pre>
{{ .ECSTask.String }}
			</pre>
		<p>
		<form action="/delete_task/{{ .Task.DynamoID }}" method="post">
  			<button type="submit" value="Submit">Delete</button>
		</form>
		</p>
	</body>
</html>`

var showTaskTextTemplate = template.Must(template.New("show_task_template").Parse(showTaskText))
