package ondemand

import "text/template"

const defaultTaskTemplateText = `{
  "networkMode": "bridge",
  "taskRoleArn": "{{.task_role_arn}}",
  "containerDefinitions": [
    {
      "portMappings": [
        {
          "containerPort": {{.container_port}},
          "protocol": "tcp"
        },
        {
          "containerPort": 6060,
          "protocol": "tcp"
        }
      ],
      "essential": true,
      "name": "{{.task_name}}",
      "readonlyRootFilesystem": true,
      "image": "{{.image}}",
      "logConfiguration": {
        "logDriver": "awslogs",
        "options": {
          "awslogs-group": "{{.container_loggroup}}",
          "awslogs-region": "{{.container_loggroup_region}}",
          "awslogs-stream-prefix": "{{.environment}}"
        }
      },
      "environment": [
        {
          "name": "ENVIRONMENT",
          "value": "{{.environment}}"
        },
        {
          "name": "GIT_COMMIT",
          "value": "{{.git_commit}}"
        }
      ],
      "cpu": {{.task_cpu}},
      "memoryReservation": {{.task_mem}}
    }
  ],
  "family": "{{.task_family}}"
}`

var _ = template.Must(template.New("default_task").Parse(defaultTaskTemplateText))
