locals {
  team        = "feeds"
  service     = "ecs-on-demand"
  dns_zone_id = "ZRG00SM48517Z"
  dns_account = "twitch-aws"
}

provider "jenkins" {
  url                = "https://jenkins.internal.justin.tv"
  shared_credentials = "${file(pathexpand("~/.jenkins_auth"))}"
}

terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "feeds/ondemand-service.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

data "terraform_remote_state" "ondemand_prod" {
  backend     = "s3"
  environment = "production"

  config {
    bucket  = "twitch-feed-aws"
    key     = "feeds/ondemand-us-west-2.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

provider "aws" {
  alias   = "dns"
  region  = "us-west-2"
  profile = "${local.dns_account}"
}

module "pipeline" {
  source         = "git::git+ssh://git@git-aws.internal.justin.tv/twitch/terraform//promotion_pipeline?ref=v0.8.10"
  team           = "${local.team}"
  service        = "${local.service}"
  git_repository = "https://git-aws.internal.justin.tv/feeds/ecs-on-demand"
}

resource "aws_route53_record" "internal_alias_record" {
  provider = "aws.dns"
  zone_id  = "${local.dns_zone_id}"
  name     = "*.${local.service}.us-west2.justin.tv"
  type     = "A"

  alias {
    name                   = "${data.terraform_remote_state.ondemand_prod.alb_dns_name}"
    zone_id                = "${data.terraform_remote_state.ondemand_prod.alb_zone_id}"
    evaluate_target_health = true
  }
}

resource "aws_route53_record" "internal_alias_record_service" {
  provider = "aws.dns"
  zone_id  = "${local.dns_zone_id}"
  name     = "${local.service}.us-west2.justin.tv"
  type     = "A"

  alias {
    name                   = "${data.terraform_remote_state.ondemand_prod.alb_dns_name}"
    zone_id                = "${data.terraform_remote_state.ondemand_prod.alb_zone_id}"
    evaluate_target_health = true
  }
}
