locals {
  service = "ecs-on-demand"

  sandstorm_role_arns = {
    staging    = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-staging"
    production = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
  }

  sandstorm_role_arn = "${lookup(local.sandstorm_role_arns, var.environment)}"

  assumed_roles = {
    feeds = "arn:aws:iam::724951484461:role/feeds-staging-build-deployment"
  }
}

variable environment {}
variable iam_id {}

// TODO: Restrict to only the correct dynamodb tables
resource "aws_iam_role_policy" "dynamodb_policy" {
  name = "${local.service}_${var.environment}_policy"
  role = "${var.iam_id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "dynamodb:*"
      ],
      "Resource": [
        "*"
      ]
    },
    {
      "Effect": "Allow",
      "Action": [
        "sns:*"
      ],
      "Resource": [
        "*"
      ]
    },
    {
      "Action": "sts:AssumeRole",
      "Resource": [
        "${local.sandstorm_role_arn}"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "assume_role_policies" {
  count = "${length(local.assumed_roles)}"
  name  = "${local.service}_${var.environment}_policy_${element(keys(local.assumed_roles), count.index)}"
  role  = "${var.iam_id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Resource": [
        "${lookup(local.assumed_roles, element(keys(local.assumed_roles), count.index))}"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}
