package pkgerrors

import "github.com/pkg/errors"

// StackExtractor supports taking stack traces out of errors wrapped by github.com/pkg/errors
type StackExtractor struct {
}

// StackTrace returns a non nil stack from iff err is wrapped by github.com/pkg/errors
func (s *StackExtractor) StackTrace(err error) []uintptr {
	type errorsStack interface {
		StackTrace() errors.StackTrace
	}
	if errsErr, ok := err.(errorsStack); ok {
		errStack := errsErr.StackTrace()
		ret := make([]uintptr, len(errStack))
		for idx, s := range errStack {
			ret[idx] = uintptr(s)
		}
		return ret
	}
	return nil
}
