package beanstalk

import (
	"encoding/json"
	"io/ioutil"

	"code.justin.tv/feeds/xray"
)

// ModifyMetadata adds aws Beanstalk information to each segment created by X-Ray
func (p *Plugin) ModifyMetadata(meta *xray.OptionalMetadata) error {
	//Assume users of this package are running on Elastic Beanstalk, which automatically creates an environment file at this location
	ebConfigPath := "/var/elasticbeanstalk/xray/environment.conf"

	rawConfig, err := ioutil.ReadFile(ebConfigPath)
	if err != nil {
		return err
	}

	config := &xray.BeanstalkMetadata{}
	err = json.Unmarshal(rawConfig, config)
	if err != nil {
		return err
	}
	meta.BeanstalkMetadata = config
	return nil
}

// Plugin allows adding beanstalk information to xray
type Plugin struct {
}
