package multistatsd

import (
	"time"
)

// StatSender is the interface cactus/go-statsd-client uses
type StatSender interface {
	Inc(string, int64, float32) error
	Dec(string, int64, float32) error
	Gauge(string, int64, float32) error
	GaugeDelta(string, int64, float32) error
	Timing(string, int64, float32) error
	TimingDuration(string, time.Duration, float32) error
	Set(string, string, float32) error
	SetInt(string, int64, float32) error
	Raw(string, string, float32) error
}

// MultiStatSender sends metrics to multiple senders
type MultiStatSender struct {
	StatSenders []StatSender
}

// Inc each StatSender
func (m *MultiStatSender) Inc(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.Inc(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Dec each StatSender
func (m *MultiStatSender) Dec(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.Dec(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Gauge each StatSender
func (m *MultiStatSender) Gauge(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.Gauge(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// GaugeDelta each StatSender
func (m *MultiStatSender) GaugeDelta(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.GaugeDelta(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Timing each StatSender
func (m *MultiStatSender) Timing(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.Timing(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// TimingDuration each StatSender
func (m *MultiStatSender) TimingDuration(s string, v time.Duration, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.TimingDuration(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Set each StatSender
func (m *MultiStatSender) Set(s string, v string, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.Set(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// SetInt each StatSender
func (m *MultiStatSender) SetInt(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.SetInt(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Raw each StatSender
func (m *MultiStatSender) Raw(s string, v string, r float32) error {
	var err error
	for _, statter := range m.StatSenders {
		if e := statter.Raw(s, v, r); e != nil {
			err = e
		}
	}
	return err
}
