package agent

import (
	. "github.com/smartystreets/goconvey/convey"
	"testing"
	"time"
)

func TestBackoff(t *testing.T) {

	Convey("Test Backoff Logic", t, func() {
		b := NewExponentialBackoff()
		b.MaxElapsedTime = 10 * time.Second
		Convey("->incrementCurrentInterval", func() {
			b.incrementCurrentInterval()
			So(b.currentInterval, ShouldEqual, time.Duration(float64(b.InitialInterval)*b.Multiplier))
		})
		Convey("->getRandomValueFromInterval", func() {
			Convey("Should return value in range [0, 2]", func() {
				nextTime := getRandomValueFromInterval(b.currentInterval, 0, b.MaxElapsedTime)
				So(nextTime, ShouldBeLessThanOrEqualTo, time.Duration(defaultInitialInterval*b.Multiplier)*time.Second)
				So(nextTime, ShouldBeGreaterThanOrEqualTo, 0)
			})
		})
	})
}
