# Deploying to AWS

1. Zip the lambda plus dependencies

```sh
$ zip -r lambdas/DynamoLambda.zip DynamoLambda.js node_modules package.json test
```

2. Go to the [Lambda Console](https://us-west-2.console.aws.amazon.com/lambda/home?region=us-west-2#/functions) and Upload

Select the appropriate sandstorm-(environment). Use `sandstorm-testing` for testing. Once this is uploaded, you can do:

```sh
$ go test ./...
```

from the project root to ensure that the current lambda works as expected with the agent.


# To test locally.
1. checkout the lambda locally
2. Install mocha on your machine using npm

```sh
$ cd  <PATH TO sandstorm/agent/lambda>
$ npm install mocha
```

2. install all the node modules required for testing.

```sh
$ npm install chai lambda-tester aws-sdk-mock --save-dev
```

3. run the tests
```sh
$ ./node_modules/mocha/bin/mocha test/
```
