package mocks

import guardian "code.justin.tv/systems/guardian/guardian"
import mock "github.com/stretchr/testify/mock"

// OAuthAuthorizer is an autogenerated mock type for the OAuthAuthorizer type
type OAuthAuthorizer struct {
	mock.Mock
}

// CheckKeys provides a mock function with given fields: keys, user
func (_m *OAuthAuthorizer) CheckKeys(keys []string, user *guardian.User) error {
	ret := _m.Called(keys, user)

	var r0 error
	if rf, ok := ret.Get(0).(func([]string, *guardian.User) error); ok {
		r0 = rf(keys, user)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// IsAdmin provides a mock function with given fields: user
func (_m *OAuthAuthorizer) IsAdmin(user *guardian.User) bool {
	ret := _m.Called(user)

	var r0 bool
	if rf, ok := ret.Get(0).(func(*guardian.User) bool); ok {
		r0 = rf(user)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// IsAllowed provides a mock function with given fields: secretName, user
func (_m *OAuthAuthorizer) IsAllowed(secretName string, user *guardian.User) error {
	ret := _m.Called(secretName, user)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, *guardian.User) error); ok {
		r0 = rf(secretName, user)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// IsCrossEnvAdmin provides a mock function with given fields: user
func (_m *OAuthAuthorizer) IsCrossEnvAdmin(user *guardian.User) bool {
	ret := _m.Called(user)

	var r0 bool
	if rf, ok := ret.Get(0).(func(*guardian.User) bool); ok {
		r0 = rf(user)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}
