package apiserver

import (
	"testing"

	"code.justin.tv/systems/guardian/guardian"

	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/assert"
)

func TestOauth(t *testing.T) {

	var oac OAuthConfig

	oauthAuthorizer := &oauthAuthorizer{
		adminSet: oac.adminSet,
	}

	Convey("Verify mapping of ldap groups to sandstorm namespaces", t, func() {
		input := []string{"team-something-admin", "team-something-sudo-admin", "team-something"}
		expectedOutput := map[string]struct{}{"something": struct{}{}}

		rawActualOutput := ldapGroupsToDynamoNamespaces(input)
		actualOutput := map[string]struct{}{}

		for _, output := range rawActualOutput {
			actualOutput[output] = struct{}{}
		}

		// make sure they are equivalent

		for group := range expectedOutput {
			_, ok := actualOutput[group]
			So(ok, ShouldBeTrue)
		}

	})
	Convey("isAllowed should return an error if secret namespace isn't in groups", t, func() {
		user := &guardian.User{Groups: []string{"namespace1", "namespace2"}}
		secretName := "namespace3/somebullshit"

		err := oauthAuthorizer.IsAllowed(secretName, user)
		So(err, ShouldNotBeNil)
	})
	Convey("isAllowed shouldn't return an error if secret namespace is in groups", t, func() {
		user := &guardian.User{Groups: []string{"namespace1", "namespace2"}}
		secretName := "namespace1/somebullshit"

		err := oauthAuthorizer.IsAllowed(secretName, user)
		So(err, ShouldBeNil)
	})

}

func TestOAuthConfig(t *testing.T) {
	t.Run("getCrossEnvAdminSet", func(t *testing.T) {
		t.Run("CrossEnvAdminGroups is len 0", func(t *testing.T) {
			assert := assert.New(t)
			cfg := &OAuthConfig{}
			assert.Equal(map[string]struct{}{}, cfg.getCrossEnvAdminSet())
		})

		t.Run("CrossEnvAdminGroups is len 1", func(t *testing.T) {
			assert := assert.New(t)
			cfg := &OAuthConfig{
				CrossEnvAdminGroups: []string{"group1"},
			}
			assert.Equal(map[string]struct{}{
				"group1": struct{}{},
			}, cfg.getCrossEnvAdminSet())
		})
	})
}
