package apiserver

import (
	"time"

	"github.com/cactus/go-statsd-client/statsd"
)

const (
	statsdHost                      = "statsd.internal.justin.tv:8125"
	metricNameChangelogEventSuccess = "changelog.sendevent.success"
	metricNameChangelogEventFailure = "changelog.sendevent.failure"
)

func newStatter(environment string) (statter statsd.Statter, err error) {
	if environment == "testing" || environment == "" {
		statter, err = statsd.NewNoopClient()
		return
	}

	prefix := "sandstorm-apiserver." + environment + ".us-west-2"

	statter, err = statsd.NewBufferedClient(statsdHost, prefix, time.Second, 0)
	return
}
