package apiserver

import (
	"encoding/json"
	"net/http"

	"github.com/sirupsen/logrus"
)

func jsonResponse(response interface{}, w http.ResponseWriter) error {
	return jsonResponseStatus(response, w, http.StatusOK)
}

func jsonResponseStatus(response interface{}, w http.ResponseWriter, statusCode int) error {
	w.Header().Set("Content-Type", contentType)
	w.WriteHeader(statusCode)
	encoder := json.NewEncoder(w)
	return encoder.Encode(response)
}

func logEntry(logger logrus.FieldLogger, r *http.Request) (entry *logrus.Entry) {
	entry = logger.WithFields(logrus.Fields{
		"method": r.Method,
		"path":   r.URL.Path,
	})

	user, err := getGuardianUser(r)
	if err == nil && user != nil {
		entry = entry.WithField("user", user.CN)
	}

	return
}
