# sandstorm-admin
sandstorm-admin contains admin commands to manage sandstorm


# Usage
```
  sandstorm-admin create-table <tablename> [--provisioned-write=<iops>] [--provisioned-read=<iops>]
  sandstorm-admin check-table <tablename>
  sandstorm-admin check-key <keyid>
  sandstorm-admin create-secret <tablename> <kmsID> <secretname> <plaintext> [--class <1..5>] [--doNotBroadcast]
  sandstorm-admin update-secret <tablename> <kmsID> <secretname> [--plaintext <plaintext>] [--class <1..5>] [--doNotBroadcast]
  sandstorm-admin delete-secret <tablename> <secretname>
  sandstorm-admin list-secrets <tablename>
  sandstorm-admin list-namespaces <tablename>
  sandstorm-admin list-namespace <tablename> <namespace>
  sandstorm-admin get-secret-encrypted <tablename> <secretname>
  sandstorm-admin get-secret <tablename> <secretname>
  sandstorm-admin copy-secret <tablename> <keyid> <source> <destination>

create-table creates the specified table with the optional amount of provisioned IOPS.
check-table verifies that the table is queryable.
check-key checks that the KMS key is useable.
create-secret uploads a new encrypted version of <plaintext> to Sandstorm named <secretname>
update-secret updates plaintext, class and/or do_not_broadcast of an existing secret.
    Note: 'do_not_broadcast' will be set to false if the option is not provided.
delete-secret will delete the secret <secretname> from table <tablename>
list-secrets will list secrets in table <tablename>
list-namespaces lists namespaces in table <tablename>
list-namespace lists secrets under namespace <namespace> in table <tablename>
```
# Options
    -h --help

# Configuration files
    ~/.aws/credentials

# Environment Variables
    AWS_REGION            AWS region to use
    AWS_ACCESS_KEY_ID     AWS access key (if not set in instance role or credentials file)
    AWS_SECRET_ACCESS_KEY AWS secret
